import {ComponentType} from 'react';

import EActionType from '../types/EActionType';
import {IIconProps} from 'icons/types/icon';

import NoOnlineRegistrationIcon from 'icons/16/NoOnlineRegistration';
import OnlineRegistrationIcon from 'icons/16/OnlineRegistration';
import CancelIcon from 'icons/16/Cancel';

export default function getActionIcon(
    actionType: EActionType,
): ComponentType<IIconProps> | undefined {
    switch (actionType) {
        case EActionType.REFUND_TICKET:
            return CancelIcon;
        case EActionType.CANCEL_TICKET_CHECKIN:
            return NoOnlineRegistrationIcon;
        case EActionType.RESTORE_TICKET_CHECKIN:
            return OnlineRegistrationIcon;
    }
}
