import {useMemo, FC} from 'react';
import {useSelector} from 'react-redux';

import orderContactInfoSelector from 'selectors/account/order/trains/orderContactInfoSelector';
import trainsOrderPassengersByGenericServicesSelector from 'selectors/account/order/trains/trainsOrderPassengersByGenericServicesSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {calculateTicketsCountByPassengers} from './../../utilities/calculateTicketsCountByPassengers';

import * as i18n from 'i18n/happyPage';

import OrderContacts from 'projects/account/pages/Order/components/OrderContacts/OrderContacts';

interface IContactsProps extends IWithQaAttributes {}

const Contacts: FC<IContactsProps> = props => {
    const contactInfo = useSelector(orderContactInfoSelector);
    const passengers = useSelector(
        trainsOrderPassengersByGenericServicesSelector,
    );

    const ticketsCount = useMemo(
        () => calculateTicketsCountByPassengers(passengers),
        [passengers],
    );

    if (!contactInfo) {
        return null;
    }

    return (
        <OrderContacts
            email={contactInfo.email}
            phone={contactInfo.phone}
            info={i18n.trainTicketsSendToEmail({ticketsCount})}
            {...prepareQaAttributes(props)}
        />
    );
};

export default Contacts;
