import React from 'react';
import {useSelector} from 'react-redux';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';

import orderNumberSelector from 'selectors/account/order/trains/orderNumberSelector';
import orderDisplayStateSelector from 'selectors/account/order/trains/orderDisplayStateSelector';
import orderTripIdSelector from 'selectors/account/order/trains/orderTripIdSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import OrderHeader from 'components/OrderHeader/OrderHeader';

interface IHeaderProps extends IWithClassName, IWithQaAttributes {}

const Header: React.FC<IHeaderProps> = props => {
    const {className} = props;

    const number = useSelector(orderNumberSelector);
    const displayState = useSelector(orderDisplayStateSelector);
    const tripId = useSelector(orderTripIdSelector);

    return (
        <OrderHeader
            className={className}
            type={EProjectName.TRAINS}
            number={number}
            displayState={displayState}
            tripId={tripId}
            {...prepareQaAttributes(props)}
        />
    );
};

export default Header;
