import {createStructuredSelector} from 'reselect';

import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';
import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import {StoreInterface} from 'reducers/storeTypes';

import orderStatusSelector from 'selectors/account/order/trains/orderStatusSelector';
import orderIdSelector from 'selectors/account/order/trains/orderIdSelector';
import {trainsOrderTypeSelector} from 'selectors/account/ordersSelector';
import hasInsuranceSelector from 'selectors/account/order/trains/hasInsuranceSelector';
import notRefundedTicketsSelector from 'selectors/account/order/trains/notRefundedTicketsSelector';
import actionsStatusSelector from 'selectors/account/order/trains/actionsStatusSelector';
import orderRemoteCheckinAllowedSelector from 'projects/account/pages/Order/components/GenericOrderTrains/components/OrderActions/selectors/orderRemoteCheckinAllowedSelector';
import orderRemoteCheckinInfoSelector, {
    IRemoteCheckinInfo,
} from 'projects/account/pages/Order/components/GenericOrderTrains/components/OrderActions/selectors/orderRemoteCheckinInfoSelector';
import orderStateSelector from 'selectors/account/order/trains/orderStateSelector';

import {ORDER_STATUS_VALUES} from 'projects/account/lib/orders/statuses';
import {STATUS} from 'projects/account/lib/orders/actionsStatuses';

import orderRefundPartInfoSelector from './orderRefundPartInfoSelector';

interface IOrderActionsSelector {
    orderStatus: ORDER_STATUS_VALUES;
    orderState: EGenericOrderState | null;
    orderId: string | undefined;
    orderType:
        | ORDER_TYPE_VALUES.TRAINS
        | ORDER_TYPE_VALUES.TRAINS_GENERIC
        | null;
    hasInsurance: boolean;
    notRefundedTickets: ITrainTicket[];
    status: STATUS;
    orderRefundPartInfo: IRefundPartInfo | null;
    orderRemoteCheckinAllowed: boolean;
    orderRemoteCheckinInfo: IRemoteCheckinInfo | null;
}

const orderActionsSelector = createStructuredSelector<
    StoreInterface,
    IOrderActionsSelector
>({
    orderStatus: orderStatusSelector,
    orderState: orderStateSelector,
    orderId: orderIdSelector,
    orderType: trainsOrderTypeSelector,
    hasInsurance: hasInsuranceSelector,
    notRefundedTickets: notRefundedTicketsSelector,
    status: actionsStatusSelector,
    orderRefundPartInfo: orderRefundPartInfoSelector,
    orderRemoteCheckinAllowed: orderRemoteCheckinAllowedSelector,
    orderRemoteCheckinInfo: orderRemoteCheckinInfoSelector,
});

export default orderActionsSelector;
