import {createSelector} from 'reselect';

import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import {trainsOrderSelector} from 'selectors/account/order/trains/trainsOrderSelector';
import timeSelector from 'selectors/common/timeSelector';

import getIsRemoteCheckinAllowedInTicket from 'projects/account/pages/Order/utilities/getIsRemoteCheckinAllowedInTicket';
import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';
import areTicketsStatusesSame from 'projects/account/pages/Order/components/GenericOrderTrains/components/OrderActions/utilities/areTicketsStatusesSame';

/**
 * Можно ли управлять электронной регистрацией для всего заказа
 */
const orderRemoteCheckinAllowedSelector = createSelector(
    [trainsOrderSelector, timeSelector],
    (order, timestamp) => {
        if (!order) {
            return false;
        }

        if (order.state === EGenericOrderState.REFUNDED) {
            return false;
        }

        const trainServices = getTrainServices(order);

        const ticketsStatusesAreSame = areTicketsStatusesSame(trainServices);

        return (
            ticketsStatusesAreSame &&
            trainServices.every(service =>
                service.trainInfo.passengers.every(
                    ({ticket}) =>
                        ticket &&
                        getIsRemoteCheckinAllowedInTicket(ticket, timestamp),
                ),
            )
        );
    },
);

export default orderRemoteCheckinAllowedSelector;
