import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';
import {TrainsOrderInfoTicketRzhdStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderInfoTicketRzhdStatus';

export default function areTicketsStatusesSame(
    services: ITrainGenericService[],
): boolean {
    let ticketStatus: TrainsOrderInfoTicketRzhdStatus | null | undefined = null;

    return services.every(service =>
        service.trainInfo.passengers.every(({ticket}) => {
            if (!ticketStatus) {
                ticketStatus = ticket?.rzhdStatus;

                return true;
            }

            return ticket?.rzhdStatus === ticketStatus;
        }),
    );
}
