import {IDevice} from 'reducers/common/commonReducerTypes';

import * as i18n from 'i18n/account-OrderTrains-Actions';

export default function getDownloadTicketButtonText(
    deviceType: IDevice,
    hasInsurance: boolean,
): string {
    if (deviceType.isMobile) {
        return i18n.download();
    }

    return hasInsurance
        ? i18n.downloadTicketsAndInsurance()
        : i18n.downloadTickets();
}
