import React from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './PassengerRefundWrapper.scss';

interface IPassengerRefundWrapperProps extends IWithClassName {
    refunded: boolean;
}

const PassengerRefundWrapper: React.FC<IPassengerRefundWrapperProps> =
    props => {
        const {className, refunded, children} = props;

        return (
            <div className={cx(className, 'root', {root_refunded: refunded})}>
                {children}
            </div>
        );
    };

export default PassengerRefundWrapper;
