import React from 'react';

import IActionItem from 'projects/account/pages/Order/components/GenericOrderTrains/components/ActionsDialog/types/IActionItem';
import {IWithClassName} from 'types/withClassName';
import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/account-OrderTrains-Passenger';

import Tooltip from 'projects/account/pages/Order/components/Tooltip/Tooltip';
import Button from 'components/Button/Button';
import Flex from 'components/Flex/Flex';
import MoreActions from './components/MoreActions/MoreActions';

import cx from './Actions.scss';

const MOBILE_TOOLTIP_DIRECTIONS = [EPopupDirection.RIGHT];

interface IActionsProps extends IWithClassName, IWithQaAttributes {
    refundActionItem: IActionItem | null;
    otherActionItems: IActionItem[];
}

const Actions: React.FC<IActionsProps> = props => {
    const {className, refundActionItem, otherActionItems} = props;

    const deviceType = useDeviceType();

    const moreActions = (
        <MoreActions
            className={cx('moreActions')}
            actionItems={otherActionItems}
            {...prepareQaAttributes(props)}
        />
    );

    const mainAction = refundActionItem && (
        <div>
            <Tooltip
                active={refundActionItem.disabled}
                content={i18nBlock.waitingForRefund()}
                directions={
                    deviceType.isMobile ? MOBILE_TOOLTIP_DIRECTIONS : undefined
                }
            >
                <Button
                    disabled={refundActionItem.disabled}
                    size={deviceType.isMobile ? 'm' : 's'}
                    theme="secondary"
                    onClick={refundActionItem.onClick}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'refundTicket',
                    })}
                >
                    {i18nBlock.refundTicket()}
                </Button>
            </Tooltip>
        </div>
    );

    return (
        <Flex
            className={cx(className)}
            inline
            between={deviceType.isMobile ? 2 : 1}
            alignItems="baseline"
        >
            {deviceType.isMobile ? (
                <>
                    {mainAction}

                    {moreActions}
                </>
            ) : (
                <>
                    {moreActions}

                    {mainAction}
                </>
            )}
        </Flex>
    );
};

export default Actions;
