import React, {useRef} from 'react';

import {IWithClassName} from 'types/withClassName';
import IActionItem from 'projects/account/pages/Order/components/GenericOrderTrains/components/ActionsDialog/types/IActionItem';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import ActionsDialog from 'projects/account/pages/Order/components/GenericOrderTrains/components/ActionsDialog/ActionsDialog';
import Button from 'components/Button/Button';
import KebabIconVertical from 'icons/16/KebabHorizontal';
import KebabIconHorizontal from 'icons/16/KebabVertical';

import cx from './MoreActions.scss';

interface IPassengerTicketMoreActionsProps
    extends IWithClassName,
        IWithQaAttributes {
    actionItems: IActionItem[];
}

const MoreActions: React.FC<IPassengerTicketMoreActionsProps> = props => {
    const {className, actionItems} = props;
    const {value: isOpened, setFalse: close, setTrue: open} = useBoolean(false);

    const moreRef = useRef<HTMLElement>(null);

    const deviceType = useDeviceType();

    if (actionItems.length === 0) {
        return null;
    }

    return (
        <div className={cx(className, 'root', deviceMods('root', deviceType))}>
            <Button
                size={deviceType.isMobile ? 'm' : 's'}
                theme={deviceType.isMobile ? 'secondary' : 'raised'}
                disabled={actionItems.some(action => action.disabled)}
                className={cx('moreButton')}
                onClick={open}
                icon={
                    deviceType.isMobile ? (
                        <KebabIconHorizontal />
                    ) : (
                        <KebabIconVertical />
                    )
                }
                innerRef={moreRef}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'moreButton',
                })}
            />

            <ActionsDialog
                actions={actionItems}
                isOpened={isOpened}
                buttonRef={moreRef}
                onClose={close}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'actionsDialog',
                })}
            />
        </div>
    );
};

export default MoreActions;
