import {useMemo} from 'react';
import {useSelector} from 'react-redux';

import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';
import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import ERefundPartState from 'server/api/GenericOrderApi/types/common/refund/ERefundPartState';

import {IRemoteCheckinInfo} from 'projects/account/pages/Order/components/GenericOrderTrains/components/OrderActions/selectors/orderRemoteCheckinInfoSelector';
import timeSelector from 'selectors/common/timeSelector';

import getIsRemoteCheckinAllowedInTicket from 'projects/account/pages/Order/utilities/getIsRemoteCheckinAllowedInTicket';
import toggleRegistrationStatusByRzhdStatus from 'projects/account/pages/Order/components/GenericOrderTrains/utilities/toggleRegistrationStatusByRzhdStatus';

export default function useRemoteCheckinInfo(
    ticket: ITrainTicket,
    refundPartInfo: IRefundPartInfo | null,
): IRemoteCheckinInfo | null {
    const timestamp = useSelector(timeSelector);

    return useMemo((): IRemoteCheckinInfo | null => {
        if (refundPartInfo?.state === ERefundPartState.DEPENDENT) {
            return null;
        }

        const remoteCheckinAllowed = getIsRemoteCheckinAllowedInTicket(
            ticket,
            timestamp,
        );

        if (!remoteCheckinAllowed || !ticket.rzhdStatus) {
            return null;
        }

        const newStatus = toggleRegistrationStatusByRzhdStatus(
            ticket.rzhdStatus,
        );

        if (!newStatus) {
            return null;
        }

        return {
            ticketIds: [ticket.blankId],
            newStatus,
        };
    }, [ticket, refundPartInfo, timestamp]);
}
