import React, {useMemo} from 'react';

import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';
import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';
import {TrainsOrderCompartmentGender} from 'server/api/TrainsBookingApi/types/TrainsOrderCompartmentGender';

import {
    getTicketPlaces,
    getTicketPlacesType,
} from 'projects/trains/lib/order/places';
import {getCoachGenderTitle} from 'projects/trains/lib/order/gender/getCoachGenderTitle';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-OrderTrains-Passenger';

import Intersperse from 'components/Intersperse/Intersperse';
import DotSeparator from 'components/DotSeparator/DotSeparator';

interface IPassengerTicketPlacesProps extends IWithQaAttributes {
    ticket: ITrainTicket;
    compartmentGender: TrainsOrderCompartmentGender | null;
}

const PassengerTicketPlaces: React.FC<IPassengerTicketPlacesProps> = props => {
    const {ticket, compartmentGender} = props;
    const {bookedTariffCode, places} = ticket;

    const placeNumbers = useMemo(() => {
        return getTicketPlaces(places);
    }, [places]);

    const placesType = useMemo(() => {
        return getTicketPlacesType(places);
    }, [places]);

    if (placeNumbers.length) {
        const coachGenderTitle = getCoachGenderTitle(compartmentGender);

        return (
            <Intersperse separator={<DotSeparator />}>
                <span
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'placeNumbers',
                    })}
                >
                    {i18nBlock.places({
                        count: placeNumbers.length,
                        places: placeNumbers.join(', '),
                    })}
                </span>
                {Boolean(placesType) && (
                    <span
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'placesType',
                        })}
                    >
                        {placesType}
                    </span>
                )}
                {Boolean(coachGenderTitle) && (
                    <span
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'coachGender',
                        })}
                    >
                        {coachGenderTitle}
                    </span>
                )}
            </Intersperse>
        );
    }

    if (bookedTariffCode === TrainBookedTariffCode.BABY) {
        return (
            <span
                {...prepareQaAttributes({
                    parent: props,
                    current: 'noPlaceBaby',
                })}
            >
                {i18nBlock.noPlaceDotBaby()}
            </span>
        );
    }

    return (
        <span {...prepareQaAttributes({parent: props, current: 'noPlace'})}>
            {i18nBlock.noPlace()}
        </span>
    );
};

export default PassengerTicketPlaces;
