import React from 'react';

import {IWithClassName} from 'types/withClassName';
import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';
import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import ERefundPartState from 'server/api/GenericOrderApi/types/common/refund/ERefundPartState';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import PassengerTicketRefundContent from './components/PassengerTicketRefundContent/PassengerTicketRefundContent';

import cx from './PassengerTicketRefund.scss';

interface IPassengerTicketRefundProps
    extends IWithClassName,
        IWithQaAttributes {
    ticket: ITrainTicket;
    refundPartInfo: IRefundPartInfo | null;
    babyRefundPartInfo: IRefundPartInfo | null;
}

const PassengerTicketRefund: React.FC<IPassengerTicketRefundProps> = props => {
    const {className, ticket, refundPartInfo, babyRefundPartInfo} = props;

    const deviceType = useDeviceType();

    if (
        !refundPartInfo ||
        refundPartInfo.state !== ERefundPartState.REFUNDED ||
        refundPartInfo?.refund?.refundAmount?.value === 0
    ) {
        return null;
    }

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            <PassengerTicketRefundContent
                ticket={ticket}
                refundPartInfo={refundPartInfo}
                babyRefundPartInfo={babyRefundPartInfo}
                {...prepareQaAttributes(props)}
            />
        </div>
    );
};

export default React.memo(PassengerTicketRefund);
