import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import IPrice from 'types/common/price/IPrice';
import {isNotNull} from 'types/utilities';

import sumPrice from 'utilities/price/sumPrice';

export default function getTotalRefundPrice(
    refundPartInfo: IRefundPartInfo,
    babyRefundPartInfo: IRefundPartInfo | null,
): IPrice {
    return sumPrice(
        ...[
            refundPartInfo.refund?.refundAmount || null,
            babyRefundPartInfo?.refund?.refundAmount || null,
        ].filter(isNotNull),
    );
}
