import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';
import {TrainsOrderInfoTicketRzhdStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderInfoTicketRzhdStatus';
import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import ERefundPartState from 'server/api/GenericOrderApi/types/common/refund/ERefundPartState';

import timeSelector from 'selectors/common/timeSelector';

import getIsRemoteCheckinAllowedInTicket from 'projects/account/pages/Order/utilities/getIsRemoteCheckinAllowedInTicket';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-OrderTrains-Passenger';

import OrderTrainsCheckin from 'projects/account/components/OrderTrainsCheckin/OrderTrainsCheckin';
import Text from 'components/Text/Text';

interface IPassengerTicketRemoteCheckinStatusProps
    extends IWithClassName,
        IWithQaAttributes {
    ticket: ITrainTicket;
    refundPartInfo: IRefundPartInfo | null;
}

const PassengerTicketRemoteCheckinStatus: React.FC<IPassengerTicketRemoteCheckinStatusProps> =
    props => {
        const {className, ticket, refundPartInfo} = props;

        const deviceType = useDeviceType();
        const timestamp = useSelector(timeSelector);

        const remoteCheckinAllowed = getIsRemoteCheckinAllowedInTicket(
            ticket,
            timestamp,
        );

        if (
            refundPartInfo?.state === ERefundPartState.DEPENDENT ||
            !remoteCheckinAllowed ||
            ticket.rzhdStatus !==
                TrainsOrderInfoTicketRzhdStatus.NO_REMOTE_CHECK_IN
        ) {
            return null;
        }

        return (
            <OrderTrainsCheckin
                className={className}
                {...prepareQaAttributes(props)}
            >
                <Text
                    size={deviceType.isDesktop ? 's' : 'm'}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'checkinCancelled',
                    })}
                >
                    {i18nBlock.checkinDotCancelled()}
                </Text>
            </OrderTrainsCheckin>
        );
    };

export default PassengerTicketRemoteCheckinStatus;
