import React from 'react';

import {ITicketWithTrainInfo} from 'projects/trains/lib/order/getPassengerWithTicketsListByGenericOrderServices';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Separator from 'components/Separator/Separator';
import Intersperse from 'components/Intersperse/Intersperse';

import PassengerTicket from '../PassengerTicket/PassengerTicket';

interface IPassengerTicketsProps extends IWithQaAttributes {
    tickets: ITicketWithTrainInfo[];
    passengerHasMultipleTickets: boolean;
}

const PassengerTickets: React.FC<IPassengerTicketsProps> = props => {
    const {tickets, passengerHasMultipleTickets} = props;

    return (
        <div {...prepareQaAttributes(props)}>
            <Intersperse separator={<Separator margin={3} />}>
                {tickets.map(ticketWithTrainInfo => {
                    if (!ticketWithTrainInfo.ticket) {
                        return null;
                    }

                    return (
                        <PassengerTicket
                            key={ticketWithTrainInfo.ticket.blankId}
                            ticketWithTrainInfo={ticketWithTrainInfo}
                            passengerHasMultipleTickets={
                                passengerHasMultipleTickets
                            }
                            {...prepareQaAttributes({
                                key: ticketWithTrainInfo.ticket.blankId,
                                current: 'ticket',
                                parent: props,
                            })}
                        />
                    );
                })}
            </Intersperse>
        </div>
    );
};

export default PassengerTickets;
