import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import trainsOrderPassengersByGenericServicesSelector from 'selectors/account/order/trains/trainsOrderPassengersByGenericServicesSelector';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/account-OrderTrains-Passengers';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Heading from 'components/Heading/Heading';
import Separator from 'components/Separator/Separator';
import Intersperse from 'components/Intersperse/Intersperse';
import TotalPrice from '../../components/TotalPrice/TotalPrice';
import Passenger from 'projects/account/pages/Order/components/GenericOrderTrains/components/Passenger/Passenger';

interface IPassengersProps extends IWithClassName, IWithQaAttributes {}

const Passengers: React.FC<IPassengersProps> = props => {
    const {className} = props;
    const deviceType = useDeviceType();
    const passengers = useSelector(
        trainsOrderPassengersByGenericServicesSelector,
    );

    return (
        <CardWithDeviceLayout
            className={className}
            below={deviceType.isMobile ? '2' : '5'}
            sectioned
            {...prepareQaAttributes(props)}
        >
            <Intersperse separator={<Separator />}>
                <CardWithDeviceLayout.Section
                    paddingBottom={deviceType.isMobile ? 3 : 4}
                >
                    <Heading
                        level={deviceType.isMobile ? 3 : 2}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'title',
                        })}
                    >
                        {i18n.title()}
                    </Heading>
                </CardWithDeviceLayout.Section>
                <Intersperse separator={<Separator />}>
                    {passengers.map(passengerWithTickets => (
                        <CardWithDeviceLayout.Section
                            paddingTop={4}
                            paddingBottom={4}
                            key={passengerWithTickets.passenger.customerId}
                        >
                            <Passenger
                                passengerWithTickets={passengerWithTickets}
                                {...prepareQaAttributes({
                                    key: passengerWithTickets.passenger
                                        .customerId,
                                    current: 'passenger',
                                    parent: props,
                                })}
                            />
                        </CardWithDeviceLayout.Section>
                    ))}
                </Intersperse>
                <CardWithDeviceLayout.Section>
                    <TotalPrice
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'totalPrice',
                        })}
                    />
                </CardWithDeviceLayout.Section>
            </Intersperse>
        </CardWithDeviceLayout>
    );
};

export default Passengers;
