import React from 'react';
import {useSelector} from 'react-redux';

import refundWarningSelector from 'projects/account/pages/Order/components/GenericOrderTrains/components/RefundActionModal/components/RefundWarning/selectors/refundWarningSelector';

import * as i18nAccountOrderBlock from 'i18n/account-Order';

import getChildrenWithoutAdultsWarning from 'projects/account/pages/Order/components/GenericOrderTrains/components/RefundActionModal/components/RefundWarning/utitlities/getChildrenWithoutAdultsWarning';

const RefundWarning: React.FC = () => {
    const {
        childrenWithoutAdultsWarningIsVisible,
        childrenMaxAge,
        isOnlyFullReturnPossible,
    } = useSelector(refundWarningSelector);

    return (
        <>
            {isOnlyFullReturnPossible && (
                <span>
                    {i18nAccountOrderBlock.trainsDotActionsDotRefundModalDotOnlyFullReturnPossible()}
                </span>
            )}

            {childrenWithoutAdultsWarningIsVisible && (
                <span>{getChildrenWithoutAdultsWarning(childrenMaxAge)}</span>
            )}
        </>
    );
};

export default RefundWarning;
