import {createSelector} from 'reselect';

import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';

import notRefundedTicketsSelector from 'selectors/account/order/trains/notRefundedTicketsSelector';

const childrenMaxAgeSelector = createSelector(
    [notRefundedTicketsSelector],
    notRefundedTickets => {
        const childrenTicket = notRefundedTickets.find(
            ticket => ticket.bookedTariffCode === TrainBookedTariffCode.CHILD,
        );

        return childrenTicket?.tariffInfo?.maxAge;
    },
);

export default childrenMaxAgeSelector;
