import {createSelector} from 'reselect';

import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';

import selectedTicketIdsSelector from 'selectors/account/order/trains/selectedTicketIdsSelector';
import notRefundedTicketsInServicesSelector from 'selectors/account/order/trains/notRefundedTicketsInServicesSelector';

const childrenWithoutAdultsWarningIsVisibleSelector = createSelector(
    [notRefundedTicketsInServicesSelector, selectedTicketIdsSelector],
    (notRefundedTicketsInServices, selectedTicketIds): boolean => {
        /**
         * Если хотя бы в одном из сервисов после возврата останется CHILD без взрослых,
         * то показываем предупреждение
         */
        return notRefundedTicketsInServices.some(
            notRefundedTicketsInService => {
                /**
                 * Билеты которые еще не вернули в сервисе
                 */
                const notRefundedTickets = notRefundedTicketsInService.tickets;

                /**
                 * Билеты которые останутся после возврата
                 */
                const notSelectedTickets = notRefundedTickets.filter(
                    ({blankId}) => !selectedTicketIds.includes(String(blankId)),
                );

                /**
                 * В билетах которые останутся после возврата есть дети
                 */
                const notSelectedTicketsHasChildren = notSelectedTickets.some(
                    ticket =>
                        ticket.bookedTariffCode === TrainBookedTariffCode.CHILD,
                );

                /**
                 * В сдаваемых билетах есть кто-то кроме детей
                 */
                const someOfRefundTicketsIsNotChildren =
                    notRefundedTickets.some(ticket => {
                        const isSelectedTicket = selectedTicketIds.includes(
                            String(ticket.blankId),
                        );

                        return (
                            isSelectedTicket &&
                            ticket.bookedTariffCode !==
                                TrainBookedTariffCode.CHILD
                        );
                    });

                return (
                    notSelectedTicketsHasChildren &&
                    someOfRefundTicketsIsNotChildren
                );
            },
        );
    },
);

export default childrenWithoutAdultsWarningIsVisibleSelector;
