import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import isOnlyFullReturnPossibleSelector from 'projects/account/pages/Order/components/GenericOrderTrains/components/RefundActionModal/selectors/isOnlyFullReturnPossibleSelector';

import childrenMaxAgeSelector from './childrenMaxAgeSelector';
import childrenWithoutAdultsWarningIsVisibleSelector from './childrenWithoutAdultsWarningIsVisibleSelector';

interface IRefundWarningSelector {
    childrenWithoutAdultsWarningIsVisible: boolean;
    childrenMaxAge: number | undefined;
    isOnlyFullReturnPossible: boolean;
}

const refundWarningSelector = createStructuredSelector<
    StoreInterface,
    IRefundWarningSelector
>({
    childrenWithoutAdultsWarningIsVisible:
        childrenWithoutAdultsWarningIsVisibleSelector,
    childrenMaxAge: childrenMaxAgeSelector,
    isOnlyFullReturnPossible: isOnlyFullReturnPossibleSelector,
});

export default refundWarningSelector;
