import {createSelector} from 'reselect';

import ERefundPartState from 'server/api/GenericOrderApi/types/common/refund/ERefundPartState';

import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

const isOnlyFullReturnPossibleSelector = createSelector(
    [trainServicesSelector],
    services => {
        return services.every(service =>
            service.trainInfo.passengers.every(passenger => {
                return (
                    passenger.refundPartInfo?.state !== ERefundPartState.ENABLED
                );
            }),
        );
    },
);

export default isOnlyFullReturnPossibleSelector;
