import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import actionsStatusesSelector from 'selectors/account/order/trains/actionsStatusesSelector';
import orderIdSelector from 'selectors/account/order/trains/orderIdSelector';
import refundAmountSelector from 'selectors/account/order/trains/refundAmountSelector';
import refundTokenSelector from 'selectors/account/order/trains/refundTokenSelector';
import totalAmountByRefundAndPenaltySelector from 'selectors/account/order/trains/totalAmountByRefundAndPenaltySelector';
import isRefundModalOpenedSelector from 'selectors/account/order/trains/isRefundModalOpenedSelector';
import hasNonRefundableTariffSelector from 'selectors/account/order/trains/hasNonRefundableTariffSelector';
import selectedTicketIdsSelector from 'selectors/account/order/trains/selectedTicketIdsSelector';
import selectedPassengerNamesSelector from 'projects/account/pages/Order/components/GenericOrderTrains/components/RefundActionModal/selectors/selectedPassengerNamesSelector';
import selectedTicketFromToSelector from 'projects/account/pages/Order/components/GenericOrderTrains/components/RefundActionModal/selectors/selectedTicketFromToSelector';
import isMultipleTrainsOrderSelector from 'selectors/account/order/trains/isMultipleTrainsOrderSelector';

import {STATUS} from 'projects/account/lib/orders/actionsStatuses';
import IPrice from 'utilities/currency/PriceInterface';

interface IRefundActionModalSelector {
    actionsStatuses: {
        updateStatus: STATUS;
        refundStatus: STATUS;
    };
    orderId: string | undefined;
    totalAmount: IPrice | null;
    refundAmount: IPrice | null;
    refundToken: string | null;
    isRefundModalOpened: boolean;
    hasNonRefundableTariff: boolean;
    selectedTicketIds: string[];
    selectedPassengerNames: string[] | null;
    selectedTicketFromTo: string | null;
    isMultipleTrainsOrder: boolean;
}

const refundActionModalSelector = createStructuredSelector<
    StoreInterface,
    IRefundActionModalSelector
>({
    actionsStatuses: actionsStatusesSelector,
    orderId: orderIdSelector,
    refundAmount: refundAmountSelector,
    totalAmount: totalAmountByRefundAndPenaltySelector,
    refundToken: refundTokenSelector,
    isRefundModalOpened: isRefundModalOpenedSelector,
    hasNonRefundableTariff: hasNonRefundableTariffSelector,
    selectedTicketIds: selectedTicketIdsSelector,
    selectedPassengerNames: selectedPassengerNamesSelector,
    selectedTicketFromTo: selectedTicketFromToSelector,
    isMultipleTrainsOrder: isMultipleTrainsOrderSelector,
});

export default refundActionModalSelector;
