import {createSelector} from 'reselect';
import flatMap from 'lodash/flatMap';

import selectedPassengersSelector from 'projects/account/pages/Order/components/GenericOrderTrains/components/RefundActionModal/selectors/selectedPassengersSelector';

import getPassengerFullName from 'projects/account/pages/Order/components/GenericOrderTrains/utilities/getPassengerFullName';

/**
 * Имена выбранных пассажиров
 */
const selectedPassengerNamesSelector = createSelector(
    [selectedPassengersSelector],
    (selectedPassengers): string[] | null => {
        if (!selectedPassengers) {
            return null;
        }

        return flatMap(selectedPassengers, ({passenger, baby}) => {
            const names = [getPassengerFullName(passenger)];

            if (baby) {
                names.push(getPassengerFullName(baby));
            }

            return names;
        });
    },
);

export default selectedPassengerNamesSelector;
