import {createSelector} from 'reselect';
import uniqBy from 'lodash/uniqBy';

import selectedTicketIdsSelector from 'selectors/account/order/trains/selectedTicketIdsSelector';
import trainsOrderPassengersByGenericServicesSelector from 'selectors/account/order/trains/trainsOrderPassengersByGenericServicesSelector';

import {IPassengerWithTickets} from 'projects/trains/lib/order/getPassengerWithTicketsListByGenericOrderServices';

/**
 * Пассажиры для которых сейчас сдаем ОДИН билет
 * для нескольких билетов вернет null
 */
const selectedPassengersSelector = createSelector(
    [selectedTicketIdsSelector, trainsOrderPassengersByGenericServicesSelector],
    (
        selectedTicketIds,
        trainsOrderPassengers,
    ): IPassengerWithTickets[] | null => {
        if (selectedTicketIds.length !== 1) {
            return null;
        }

        const [selectedTicketId] = selectedTicketIds;

        const passengers = trainsOrderPassengers.filter(
            passengerWithTickets => {
                return passengerWithTickets.tickets.find(
                    ticket =>
                        selectedTicketId === String(ticket.ticket?.blankId),
                );
            },
        );

        return uniqBy(passengers, ({passenger}) => passenger.customerId);
    },
);

export default selectedPassengersSelector;
