import {createSelector} from 'reselect';

import selectedTicketIdsSelector from 'selectors/account/order/trains/selectedTicketIdsSelector';
import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

import {CHAR_EM_DASH} from 'utilities/strings/charCodes';
import getFromToByStations from 'projects/trains/lib/getFromToByStations';

/**
 * Откуда и куда едет поезд для выбранного билета
 */
const selectedTicketFromToSelector = createSelector(
    [selectedTicketIdsSelector, trainServicesSelector],
    (selectedTicketIds, services): string | null => {
        if (selectedTicketIds.length !== 1) {
            return null;
        }

        const [selectedTicketId] = selectedTicketIds;

        for (const service of services) {
            const {trainInfo} = service;

            for (const passenger of trainInfo.passengers) {
                if (String(passenger.ticket?.blankId) !== selectedTicketId) {
                    continue;
                }

                const {stationFrom, stationTo} = trainInfo;

                const {from, to} = getFromToByStations({
                    stationFrom,
                    stationTo,
                });

                return `${from} ${CHAR_EM_DASH} ${to}`;
            }
        }

        return null;
    },
);

export default selectedTicketFromToSelector;
