import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {batchActions} from 'redux-batched-actions';

import {ORDER_TRAINS_REGISTRATION_STATUS} from 'projects/account/pages/Order/types/OrderTrainsRegistrationStatus';

import * as actions from 'reducers/account/orders/actions';

import registrationActionModalSelector from 'projects/account/pages/Order/components/GenericOrderTrains/components/RegistrationActionModal/selectors/registrationActionModalSelector';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nAccountOrderBlock from 'i18n/account-Order';

import OrderActionModal from '../OrderActionModal/OrderActionModal';

const RegistrationActionModal: React.FC = () => {
    const deviceType = useDeviceType();

    const {
        orderId,
        selectedTickets,
        isRegistrationModalOpened,
        requestedRegistrationStatus,
        actionsStatuses: {updateStatus},
    } = useSelector(registrationActionModalSelector);
    const dispatch = useDispatch();

    const handleSubmit = useCallback(() => {
        if (!orderId || !requestedRegistrationStatus) {
            return;
        }

        dispatch(
            actions.orderRegistrationStatusUpdate.request({
                orderId,
                blankIds: selectedTickets,
                newStatus: requestedRegistrationStatus,
            }),
        );
    }, [dispatch, orderId, selectedTickets, requestedRegistrationStatus]);

    const handleClose = useCallback(() => {
        dispatch(
            batchActions([
                actions.setSelectedTickets([]),
                actions.setRegistrationModalOpenedState(false),
            ]),
        );
    }, [dispatch]);

    const disabledRegistrationStatus =
        requestedRegistrationStatus ===
        ORDER_TRAINS_REGISTRATION_STATUS.DISABLED;

    return (
        <OrderActionModal
            isVisible={isRegistrationModalOpened}
            deviceType={deviceType}
            onClose={handleClose}
            onSubmit={handleSubmit}
            status={updateStatus}
            title={
                disabledRegistrationStatus
                    ? i18nAccountOrderBlock.actionsDotCancelTicketCheckinTitle()
                    : i18nAccountOrderBlock.actionsDotRestoreTicketCheckinTitle()
            }
            cancelName={
                disabledRegistrationStatus
                    ? i18nAccountOrderBlock.actionsDotCancelCancelTicketCheckin()
                    : i18nAccountOrderBlock.actionsDotCancelRestoreTicketCheckinTitle()
            }
            submitName={
                disabledRegistrationStatus
                    ? i18nAccountOrderBlock.actionsDotConfirmCancelTicketCheckin()
                    : i18nAccountOrderBlock.actionsDotConfirmRestoreTicketCheckinTitle()
            }
            {...prepareQaAttributes('orderTrainsOrchActionModal')}
        />
    );
};

export default RegistrationActionModal;
