import {createStructuredSelector} from 'reselect';

import {ORDER_TRAINS_REGISTRATION_STATUS} from 'projects/account/pages/Order/types/OrderTrainsRegistrationStatus';

import {StoreInterface} from 'reducers/storeTypes';

import requestedRegistrationStatusSelector from 'selectors/account/order/trains/requestedRegistrationStatusSelector';
import isRegistrationModalOpenedSelector from 'selectors/account/order/trains/isRegistrationModalOpenedSelector';
import actionsStatusesSelector from 'selectors/account/order/trains/actionsStatusesSelector';
import orderIdSelector from 'selectors/account/order/trains/orderIdSelector';
import selectedTicketIdsSelector from 'selectors/account/order/trains/selectedTicketIdsSelector';

import {STATUS} from 'projects/account/lib/orders/actionsStatuses';

interface IRegistrationActionModalSelector {
    requestedRegistrationStatus: ORDER_TRAINS_REGISTRATION_STATUS | null;
    isRegistrationModalOpened: boolean;
    actionsStatuses: {
        updateStatus: STATUS;
        refundStatus: STATUS;
    };
    orderId: string | undefined;
    selectedTickets: string[];
}

const registrationActionModalSelector = createStructuredSelector<
    StoreInterface,
    IRegistrationActionModalSelector
>({
    requestedRegistrationStatus: requestedRegistrationStatusSelector,
    isRegistrationModalOpened: isRegistrationModalOpenedSelector,
    actionsStatuses: actionsStatusesSelector,
    orderId: orderIdSelector,
    selectedTickets: selectedTicketIdsSelector,
});

export default registrationActionModalSelector;
