import EFiscalReceiptType from 'server/api/GenericOrderApi/types/common/EFiscalReceiptType';
import IReceiptItem from 'server/api/GenericOrderApi/types/common/IReceiptItem';

import {StoreInterface} from 'reducers/storeTypes';

import orderReceiptsSelector from 'selectors/account/order/trains/orderReceiptsSelector';

export default function paymentReceiptSelector(
    state: StoreInterface,
): IReceiptItem | undefined {
    const orderReceipts = orderReceiptsSelector(state);

    return orderReceipts.find(
        receipt => receipt.type === EFiscalReceiptType.ACQUIRE,
    );
}
