import EFiscalReceiptType from 'server/api/GenericOrderApi/types/common/EFiscalReceiptType';
import IReceiptItem from 'server/api/GenericOrderApi/types/common/IReceiptItem';

import {StoreInterface} from 'reducers/storeTypes';

import orderReceiptsSelector from 'selectors/account/order/trains/orderReceiptsSelector';

export default function refundReceiptsSelector(
    state: StoreInterface,
): IReceiptItem[] {
    const orderReceipts = orderReceiptsSelector(state);

    return orderReceipts
        .filter(
            receipt =>
                receipt.type === EFiscalReceiptType.CLEAR ||
                receipt.type === EFiscalReceiptType.REFUND,
        )
        .reverse();
}
