import {createStructuredSelector} from 'reselect';

import IReceiptItem from 'server/api/GenericOrderApi/types/common/IReceiptItem';

import {StoreInterface} from 'reducers/storeTypes';

import orderStatusSelector from 'selectors/account/order/trains/orderStatusSelector';
import hasInsuranceSelector from 'selectors/account/order/trains/hasInsuranceSelector';
import orderTotalPriceSelector from 'selectors/account/order/trains/orderTotalPriceSelector';
import orderTotalRefundAmountSelector from 'selectors/account/order/trains/orderTotalRefundAmountSelector';

import {ORDER_STATUS_VALUES} from 'projects/account/lib/orders/statuses';
import IPrice from 'utilities/currency/PriceInterface';

import paymentReceiptSelector from './paymentReceiptSelector';
import refundReceiptsSelector from './refundReceiptsSelector';

interface ITotalPriceSelector {
    status: ORDER_STATUS_VALUES;
    hasInsurance: boolean;
    orderTotalPrice: IPrice | undefined;
    orderTotalRefundAmount: IPrice | undefined | null;
    paymentReceipt: IReceiptItem | undefined;
    refundReceipts: IReceiptItem[];
}

const totalPriceSelector = createStructuredSelector<
    StoreInterface,
    ITotalPriceSelector
>({
    status: orderStatusSelector,
    hasInsurance: hasInsuranceSelector,
    orderTotalPrice: orderTotalPriceSelector,
    orderTotalRefundAmount: orderTotalRefundAmountSelector,
    paymentReceipt: paymentReceiptSelector,
    refundReceipts: refundReceiptsSelector,
});

export default totalPriceSelector;
