import React, {useEffect} from 'react';
import {useSelector} from 'react-redux';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import orderWarningsSelector from './selectors/orderWarningsSelector';

import {reachGoal} from 'utilities/metrika';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {getWarningMessage} from 'projects/account/pages/Order/components/GenericOrderTrains/components/Warnings/utilities/getWarningMessage';

import NotificationBanner from 'components/NotificationBanner/NotificationBanner';

interface IWarningsProps extends IWithQaAttributes {}

const Warnings: React.FC<IWarningsProps> = props => {
    const warnings = useSelector(orderWarningsSelector);
    const deviceType = useDeviceType();

    useEffect(() => {
        if (!warnings.length) {
            return;
        }

        reachGoal(ETrainsGoal.ORDER_WARNING_SHOW, {
            trains: {
                order_page_warning: warnings
                    .map(({warningCode}) => warningCode)
                    .join(', '),
            },
        });
    }, [warnings]);

    if (!warnings.length) {
        return null;
    }

    return (
        <NotificationBanner
            below={deviceType.isMobile ? 2 : 5}
            {...prepareQaAttributes(props)}
        >
            {warnings.map(warning => (
                <span
                    key={warning.key}
                    {...prepareQaAttributes({
                        key: warning.key,
                        parent: props,
                        current: 'warning',
                    })}
                >
                    {getWarningMessage(warning)}
                </span>
            ))}
        </NotificationBanner>
    );
};

export default Warnings;
