import React from 'react';

import {ETrainsOrderInfoWarningCode} from 'server/api/TrainsBookingApi/types/ETrainsOrderInfoWarningCode';

import {getLinkText} from './utilities/getLinkText';
import {REFUND_LINK} from 'projects/account/lib/orders/links';

import Link from 'components/Link/Link';

interface IHelpLinkProps {
    warningCode: ETrainsOrderInfoWarningCode;
}

const HelpLink: React.FC<IHelpLinkProps> = props => {
    const {warningCode} = props;

    const linkText = getLinkText(warningCode);

    if (!linkText) {
        return null;
    }

    return (
        <Link url={REFUND_LINK} target="_blank" rel="noopener noreferrer">
            {linkText}
        </Link>
    );
};

export default HelpLink;
