import {ETrainsOrderInfoWarningCode} from 'server/api/TrainsBookingApi/types/ETrainsOrderInfoWarningCode';

import * as i18n from 'i18n/trains-order-warnings';

export function getLinkText(
    code: ETrainsOrderInfoWarningCode,
): string | undefined {
    switch (code) {
        case ETrainsOrderInfoWarningCode.ELECTRONIC_REGISTRATION_ALMOST_EXPIRED:
            return i18n.electronicRegistrationAlmostExpiredLink();
        case ETrainsOrderInfoWarningCode.ELECTRONIC_REGISTRATION_EXPIRED:
            return i18n.electronicRegistrationExpiredLink();
        case ETrainsOrderInfoWarningCode.HAS_NON_REFUNDABLE_TARIFF:
            return i18n.hasNonRefundableTariffLink();
        case ETrainsOrderInfoWarningCode.TICKETS_TAKEN_AWAY:
            return i18n.ticketsTakenAwayLink();
        case ETrainsOrderInfoWarningCode.TRAIN_ALMOST_LEFT_DEPARTURE_STATION:
            return i18n.trainAlmostLeftDepartureStationLink();
        case ETrainsOrderInfoWarningCode.TRAIN_LEFT_DEPARTURE_STATION:
            return i18n.trainLeftDepartureStationLink();
        case ETrainsOrderInfoWarningCode.TRAIN_LEFT_START_STATION:
            return i18n.trainLeftStartStationLink();
        default:
            return undefined;
    }
}
