import ETrainWarningMessageCode from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainWarningInfo/ETrainWarningMessageCode';
import {ETrainsOrderInfoWarningCode} from 'server/api/TrainsBookingApi/types/ETrainsOrderInfoWarningCode';
import EWarningItemParam from '../types/EWarningItemParam';

const COMMON_PARAMS = [EWarningItemParam.WARNING_CODE];

/**
 * Параметры по которым находятся одинаковые предупреждения
 */
const MAP_CODE_TO_PARAMETERS: Record<
    ETrainWarningMessageCode,
    EWarningItemParam[]
> = {
    [ETrainsOrderInfoWarningCode.ELECTRONIC_REGISTRATION_ALMOST_EXPIRED]: [
        ...COMMON_PARAMS,
        EWarningItemParam.WARNING_TO,
        EWarningItemParam.TRAIN_NUMBER,
    ],
    [ETrainsOrderInfoWarningCode.ELECTRONIC_REGISTRATION_EXPIRED]: [
        ...COMMON_PARAMS,
        EWarningItemParam.START_STATION,
        EWarningItemParam.TRAIN_NUMBER,
    ],
    [ETrainsOrderInfoWarningCode.HAS_NON_REFUNDABLE_TARIFF]: [...COMMON_PARAMS],
    [ETrainsOrderInfoWarningCode.INSURANCE_AUTO_RETURN]: [...COMMON_PARAMS],
    [ETrainsOrderInfoWarningCode.TICKETS_TAKEN_AWAY]: [...COMMON_PARAMS],
    [ETrainsOrderInfoWarningCode.TRAIN_ALMOST_LEFT_DEPARTURE_STATION]: [
        ...COMMON_PARAMS,
        EWarningItemParam.WARNING_TO,
        EWarningItemParam.TRAIN_NUMBER,
    ],
    [ETrainsOrderInfoWarningCode.TRAIN_LEFT_DEPARTURE_STATION]: [
        ...COMMON_PARAMS,
        EWarningItemParam.DEPARTURE_STATION,
        EWarningItemParam.TRAIN_NUMBER,
    ],
    [ETrainsOrderInfoWarningCode.TRAIN_LEFT_START_STATION]: [
        ...COMMON_PARAMS,
        EWarningItemParam.START_STATION,
        EWarningItemParam.TRAIN_NUMBER,
    ],
    [ETrainsOrderInfoWarningCode.ALMOST_SIX_HOURS_TO_DEPARTURE]: [
        ...COMMON_PARAMS,
    ],
    [ETrainsOrderInfoWarningCode.LESS_THEN_SIX_HOURS_TO_DEPARTURE]: [
        ...COMMON_PARAMS,
    ],
};

export default function getParametersByCode(
    code: ETrainWarningMessageCode,
): EWarningItemParam[] {
    return MAP_CODE_TO_PARAMETERS[code];
}
