import React from 'react';

import {ETrainsOrderInfoWarningCode} from 'server/api/TrainsBookingApi/types/ETrainsOrderInfoWarningCode';

import {IWarningItem} from 'projects/account/pages/Order/components/GenericOrderTrains/components/Warnings/selectors/orderWarningsSelector';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18n from 'i18n/trains-order-warnings';

import MinuteTimer from '../components/MinuteTimer/MinuteTimer';
import HelpLink from '../components/HelpLink/HelpLink';

export function getWarningMessage(
    warningItem: IWarningItem,
): string | React.ReactElement | null {
    const {
        warningCode,
        warningTo,
        startStation,
        departureStation,
        trainNumber,
    } = warningItem;

    const timeLeft = <MinuteTimer timeLeftAt={warningTo} />;
    const link = <HelpLink warningCode={warningCode} />;

    switch (warningCode) {
        case ETrainsOrderInfoWarningCode.ELECTRONIC_REGISTRATION_ALMOST_EXPIRED:
            return insertJSXIntoKey(i18n.electronicRegistrationAlmostExpired)({
                timeLeft,
                link,
                trainNumber,
            });
        case ETrainsOrderInfoWarningCode.ELECTRONIC_REGISTRATION_EXPIRED:
            return insertJSXIntoKey(i18n.electronicRegistrationExpired)({
                startStation,
                link,
                trainNumber,
            });
        case ETrainsOrderInfoWarningCode.HAS_NON_REFUNDABLE_TARIFF:
            return insertJSXIntoKey(i18n.hasNonRefundableTariff)({link});
        case ETrainsOrderInfoWarningCode.INSURANCE_AUTO_RETURN:
            return i18n.insuranceAutoReturn();
        case ETrainsOrderInfoWarningCode.TICKETS_TAKEN_AWAY:
            return insertJSXIntoKey(i18n.ticketsTakenAway)({link});
        case ETrainsOrderInfoWarningCode.TRAIN_ALMOST_LEFT_DEPARTURE_STATION:
            return insertJSXIntoKey(i18n.trainAlmostLeftDepartureStation)({
                timeLeft,
                link,
                trainNumber,
            });
        case ETrainsOrderInfoWarningCode.TRAIN_LEFT_DEPARTURE_STATION:
            return insertJSXIntoKey(i18n.trainLeftDepartureStation)({
                departureStation,
                link,
                trainNumber,
            });
        case ETrainsOrderInfoWarningCode.TRAIN_LEFT_START_STATION:
            return insertJSXIntoKey(i18n.trainLeftStartStation)({
                startStation,
                link,
                trainNumber,
            });
        default:
            return null;
    }
}
