import {useDispatch, useSelector} from 'react-redux';
import {useMemo} from 'react';
import {batchActions} from 'redux-batched-actions';

import IActionItem from 'projects/account/pages/Order/components/GenericOrderTrains/components/ActionsDialog/types/IActionItem';
import EActionType from 'projects/account/pages/Order/components/GenericOrderTrains/components/ActionsDialog/types/EActionType';
import {ORDER_TRAINS_REGISTRATION_STATUS} from 'projects/account/pages/Order/types/OrderTrainsRegistrationStatus';

import * as actions from 'reducers/account/orders/actions';

import actionsStatusSelector from 'selectors/account/order/trains/actionsStatusSelector';
import {IRemoteCheckinInfo} from 'projects/account/pages/Order/components/GenericOrderTrains/components/OrderActions/selectors/orderRemoteCheckinInfoSelector';

import {STATUS} from 'projects/account/lib/orders/actionsStatuses';

export default function useChangeRemoteCheckinActionItem(
    params: IRemoteCheckinInfo | null,
): IActionItem | null {
    const status = useSelector(actionsStatusSelector);
    const dispatch = useDispatch();

    return useMemo(() => {
        if (!params) {
            return null;
        }

        const {newStatus, ticketIds} = params;

        if (!ticketIds.length) {
            return null;
        }

        return {
            type:
                newStatus === ORDER_TRAINS_REGISTRATION_STATUS.ENABLED
                    ? EActionType.RESTORE_TICKET_CHECKIN
                    : EActionType.CANCEL_TICKET_CHECKIN,
            onClick: (): void => {
                dispatch(
                    batchActions([
                        actions.setSelectedTickets(ticketIds.map(String)),
                        actions.setRequestedRegistrationStatus(newStatus),
                        actions.setRegistrationModalOpenedState(true),
                    ]),
                );
            },
            disabled: status === STATUS.PENDING,
        };
    }, [params, status, dispatch]);
}
