import {useEffect} from 'react';
import moment from 'moment';
import {useSelector} from 'react-redux';

import {MINUTE} from 'utilities/dateUtils/constants';

import reloadOrderAtSelector from 'selectors/account/order/trains/reloadOrderAtSelector';

import {getNow} from 'utilities/dateUtils';

interface IUseReloadOrderParams {
    updateOrder: (isBackground: boolean) => void;
}

/**
 * Обновляем заказ по времени указанном в заказе
 */
export default function useReloadAtOrder(params: IUseReloadOrderParams): void {
    const {updateOrder} = params;
    const reloadAt = useSelector(reloadOrderAtSelector);

    useEffect(() => {
        if (!reloadAt) {
            return;
        }

        const intervalID = setInterval(() => {
            const isAfter = moment(getNow()).isAfter(reloadAt);

            if (!isAfter) {
                return;
            }

            updateOrder(true);
        }, MINUTE);

        return (): void => {
            clearInterval(intervalID);
        };
    }, [reloadAt, updateOrder]);
}
