import _sumBy from 'lodash/sumBy';

import {IPassengerWithTickets} from 'projects/trains/lib/order/getPassengerWithTicketsListByGenericOrderServices';

export const calculateTicketsCountByPassengers = (
    passengers: IPassengerWithTickets[],
): number => {
    if (!passengers) {
        return 0;
    }

    return _sumBy(passengers, passenger => passenger.tickets.length);
};
