import {TrainsOrderInfoTicketRzhdStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderInfoTicketRzhdStatus';
import {ORDER_TRAINS_REGISTRATION_STATUS} from 'projects/account/pages/Order/types/OrderTrainsRegistrationStatus';

export default function toggleRegistrationStatusByRzhdStatus(
    status: TrainsOrderInfoTicketRzhdStatus | undefined,
): ORDER_TRAINS_REGISTRATION_STATUS | null {
    if (status === TrainsOrderInfoTicketRzhdStatus.REMOTE_CHECK_IN) {
        return ORDER_TRAINS_REGISTRATION_STATUS.DISABLED;
    }

    if (status === TrainsOrderInfoTicketRzhdStatus.NO_REMOTE_CHECK_IN) {
        return ORDER_TRAINS_REGISTRATION_STATUS.ENABLED;
    }

    return null;
}
