import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {getBackLinkInfo} from './utilities/getBackLinkInfo';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import ArrowLeftIcon from 'icons/16/ArrowLeft';
import Link from 'components/Link/Link';

interface IOrderBackLinkProps extends IWithClassName, IWithQaAttributes {
    tripId?: string | null;
}

const OrderBackLink: React.FC<IOrderBackLinkProps> = props => {
    const {className, tripId} = props;
    const backLinkInfo = useMemo(() => {
        return getBackLinkInfo(tripId);
    }, [tripId]);

    return (
        <Link
            className={className}
            to={backLinkInfo.url}
            onClick={backLinkInfo.handleClick}
            theme="black"
            {...prepareQaAttributes(props)}
        >
            <TextWithIcon
                text={backLinkInfo.text}
                iconLeft={ArrowLeftIcon}
                size="m"
            />
        </Link>
    );
};

export default OrderBackLink;
