import React from 'react';

import {
    IBookHotelCheckin,
    IBookHotelCheckout,
} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {
    prepareCheckinCheckoutTime,
    prepareSearchDate,
} from 'projects/hotels/utilities/getHotelCheckDates/getHotelCheckDates';
import {CHAR_EM_DASH} from 'utilities/strings/charCodes';

import * as i18nBlock from 'i18n/hotels-HotelCheckDates';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

interface ICheckinCheckoutDatesProps extends IWithClassName, IWithQaAttributes {
    checkin: IBookHotelCheckin;
    checkout: IBookHotelCheckout;
    checkinDate: string;
    checkoutDate: string;
}

const CheckinCheckoutDates: React.FC<ICheckinCheckoutDatesProps> = props => {
    const {className, checkin, checkout, checkinDate, checkoutDate} = props;

    const {checkinText, checkoutText} = prepareCheckinCheckoutTime({
        checkin,
        checkout,
    });
    const checkinDateText = prepareSearchDate(checkinDate);
    const checkoutDateText = prepareSearchDate(checkoutDate);

    return (
        <Flex
            className={className}
            flexDirection="column"
            {...prepareQaAttributes(props)}
        >
            <Text weight="bold">
                <span
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'checkinDate',
                    })}
                >
                    {checkinDateText}
                </span>{' '}
                {CHAR_EM_DASH}{' '}
                <span
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'checkoutDate',
                    })}
                >
                    {checkoutDateText}
                </span>
            </Text>
            <Text>
                {i18nBlock.checkinDotTitle()}{' '}
                <span
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'checkinTime',
                    })}
                >
                    {checkinText}
                </span>
            </Text>
            <Text>
                {i18nBlock.checkoutDotTitle()}{' '}
                <span
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'checkoutTime',
                    })}
                >
                    {checkoutText}
                </span>
            </Text>
        </Flex>
    );
};

export default React.memo(CheckinCheckoutDates);
