import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Text, {ITextProps} from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

interface IDetailItemProps
    extends IWithClassName,
        IWithQaAttributes,
        Pick<ITextProps, 'size' | 'color'> {
    title: React.ReactNode;
    price: React.ReactNode;
    additional?: React.ReactNode;
}

const DetailItem: React.FC<IDetailItemProps> = props => {
    const {className, title, price, size, color, additional} = props;

    return (
        <div {...prepareQaAttributes(props)}>
            <Flex
                className={className}
                inline
                alignItems="baseline"
                between={2}
                justifyContent="space-between"
            >
                <Text
                    size={size}
                    color={color}
                    {...prepareQaAttributes({parent: props, current: 'title'})}
                >
                    {title}
                </Text>
                <Text
                    size={size}
                    color={color}
                    {...prepareQaAttributes({parent: props, current: 'price'})}
                >
                    {price}
                </Text>
            </Flex>
            {additional && (
                <div
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'additional',
                    })}
                >
                    {additional}
                </div>
            )}
        </div>
    );
};

export default DetailItem;
