import React from 'react';

import {
    EYandexPlusApplicationMode,
    IAppliedPromoCampaigns,
} from 'types/hotels/offer/IHotelOffer';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-plusPromo2021';

import CommonPlusInfo from 'components/PlusInfo/PlusInfo';
import {TBoxSizes} from 'components/Box/Box';

interface IPlusInfoProps extends IWithQaAttributes {
    appliedPromoCampaigns: IAppliedPromoCampaigns | undefined;
    /**
     * Отображаем списание или начисление
     */
    yandexPlusMode: EYandexPlusApplicationMode;
    direction?: React.CSSProperties['flexDirection'];
    justifyContent?: React.CSSProperties['justifyContent'];
    between?: TBoxSizes;
}

const PlusInfo: React.FC<IPlusInfoProps> = props => {
    const {
        appliedPromoCampaigns,
        yandexPlusMode,
        direction,
        justifyContent,
        between,
    } = props;
    const yandexPlus = appliedPromoCampaigns?.yandexPlus;

    if (!yandexPlus || yandexPlus.mode !== yandexPlusMode) {
        return null;
    }

    return (
        <CommonPlusInfo
            size="m"
            plusPoints={yandexPlus.points}
            isDiscount={yandexPlus.mode === EYandexPlusApplicationMode.WITHDRAW}
            popupTitle={i18nBlock.plusInfoTitle()}
            popupText={i18nBlock.plusInfoTextV2()}
            direction={direction}
            justifyContent={justifyContent}
            between={between}
            {...prepareQaAttributes(props)}
        />
    );
};

export default PlusInfo;
