import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EPromoCodesApplicationType} from 'types/hotels/book/IApplyPromoCodes';
import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Details from './Details';

export default {
    title: 'Account/Details',
    component: Details,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Details
        appliedPromoCampaigns={{
            yandexPlus: {
                mode: EYandexPlusApplicationMode.WITHDRAW,
                points: 100,
            },
        }}
        hotelPrice={{
            amount: '30000',
            currency: CurrencyType.RUB,
        }}
        nights={[
            {
                hotelBase: {
                    amount: '15000.00',
                    currency: CurrencyType.RUB,
                },
                taxesAndFees: [],
            },
            {
                hotelBase: {
                    amount: '15000.00',
                    currency: CurrencyType.RUB,
                },
                taxesAndFees: [],
            },
        ]}
        discount={{
            amount: '100.00',
            currency: CurrencyType.RUB,
        }}
        taxesAndFeesSum={{
            amount: '300.00',
            currency: CurrencyType.RUB,
        }}
        amountPaid={{
            value: 1,
            currency: CurrencyType.RUB,
        }}
        totalPrice={{
            value: 10000,
            currency: CurrencyType.RUB,
        }}
        codeApplicationResults={[
            {
                code: 'AUTOTEST_PROMOCODE_2OO',
                type: EPromoCodesApplicationType.SUCCESS,
                discountAmount: {
                    value: 200,
                    currency: CurrencyType.RUB,
                },
            },
        ]}
        legalInfo={[
            {
                source: 'hotel',
                name: 'АО ТГК "ВЕГА"',
                ogrn: '1027739012003',
                registryNumber: '',
                workingHours: 'ежедневно, круглосуточно',
                legalAddress:
                    '105613, МОСКВА ГОРОД, ШОССЕ ИЗМАЙЛОВСКОЕ, ДОМ 71, КОРПУС 3В, ЭТАЖ 3 ПОМЕЩЕНИЕ 26',
                actualAddress:
                    'Россия, Москва, Измайловское шоссе, 71, корп. 3В',
            },
            {
                source: 'yandex',
                name: 'Сервис предоставляет ООО «Яндекс»',
                ogrn: '1027700229193',
                registryNumber: '',
                workingHours:
                    'пн-пт: с 9:00 до 20:00 по местному времени, сб и вс: выходной',
                legalAddress:
                    '119021, Россия, г. Москва, ул. Льва Толстого, д. 16',
                actualAddress: '',
            },
        ]}
    />
);

Simple.parameters = {
    info: {
        title: 'Подробности цены в отельном заказе',
    },
};
