import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import TotalPrice from './TotalPrice';

export default {
    title: 'Account/TotalPrice',
    component: TotalPrice,
} as Meta;

export const OnlyTotalPrice: TStorybookFunctionComponent = () => {
    return (
        <TotalPrice
            amountPaid={undefined}
            totalPrice={{
                value: 29800,
                currency: CurrencyType.RUB,
            }}
        />
    );
};

OnlyTotalPrice.parameters = {
    info: {
        title: 'Бронирование c полной оплатой',
    },
};

export const FreeBooking: TStorybookFunctionComponent = () => {
    return (
        <TotalPrice
            amountPaid={{
                value: 0,
                currency: CurrencyType.RUB,
            }}
            totalPrice={{
                value: 29800,
                currency: CurrencyType.RUB,
            }}
        />
    );
};

FreeBooking.parameters = {
    info: {
        title: 'Бронирование без предоплат',
    },
};

export const PrepayBooking: TStorybookFunctionComponent = () => {
    return (
        <TotalPrice
            amountPaid={{
                value: 100,
                currency: CurrencyType.RUB,
            }}
            totalPrice={{
                value: 29800,
                currency: CurrencyType.RUB,
            }}
        />
    );
};

PrepayBooking.parameters = {
    info: {
        title: 'Бронирование с предоплатой',
    },
};
