import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import IPrice from 'utilities/currency/PriceInterface';

import * as i18nBlock from 'i18n/account-OrderHotels-Price';

import PartialPrice from 'components/PartialPrice/PartialPrice';
import FieldLabel from 'components/FieldLabel/FieldLabel';

interface ITotalPriceProps extends IWithClassName, IWithQaAttributes {
    amountPaid: IPrice | undefined;
    totalPrice: IPrice;
}

const TotalPrice: React.FC<ITotalPriceProps> = props => {
    const {className, amountPaid, totalPrice} = props;

    const deviceType = useDeviceType();

    return (
        <FieldLabel
            className={className}
            label={i18nBlock.paidTitle()}
            labelColor="primary"
            labelSize="m"
            valueSize={deviceType.isDesktop ? 'xl' : 'l'}
            valueWeight="medium"
            between={deviceType.isDesktop ? 1 : undefined}
            {...prepareQaAttributes({parent: props, current: 'fieldLabel'})}
        >
            <PartialPrice
                price={amountPaid}
                totalPrice={totalPrice}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'partialPrice',
                })}
            />
        </FieldLabel>
    );
};

export default TotalPrice;
