import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {CHAR_NBSP} from 'utilities/strings/charCodes';
import {hotelsURLs} from 'projects/hotels/utilities/urls';

import Link from 'components/Link/Link';
import HotelStars from 'components/HotelStars/HotelStars';
import Heading from 'components/Heading/Heading';

import cx from './OrderHotelName.scss';

interface IOrderHotelNameProps extends IWithClassName, IWithQaAttributes {
    name: string;
    stars: number;
    hotelSlug: HotelSlugType;
}

const OrderHotelName: React.FC<IOrderHotelNameProps> = props => {
    const {className, name, stars, hotelSlug} = props;

    const hotelUrl = hotelsURLs.getHotelUrlByHotelSlug(hotelSlug);

    return (
        <Link
            className={cx(className, 'root')}
            url={hotelUrl}
            target="_blank"
            theme="black"
            {...prepareQaAttributes(props)}
        >
            <Heading level={1}>
                {name}
                {CHAR_NBSP}
                <HotelStars stars={stars} size="16" />
            </Heading>
        </Link>
    );
};

export default OrderHotelName;
