import React from 'react';

import {
    IOrderPayment,
    IOrderPrice,
} from 'server/api/HotelsBookAPI/types/IOrder';
import {IBookHotelInfo} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {IAppliedPromoCampaigns} from 'types/hotels/offer/IHotelOffer';

import IPrice from 'utilities/currency/PriceInterface';

import * as i18nBlock from 'i18n/account-OrderHotels-Price';

import Flex from 'components/Flex/Flex';
import Price from 'components/Price/Price';
import FieldLabel from 'components/FieldLabel/FieldLabel';
import RefundReceiptsAndDocs from 'projects/account/pages/Order/components/OrderHotels/components/OrderHotelsCancelledInfo/components/OrderHotelRefund/components/RefundReceiptsAndDocs/RefundReceiptsAndDocs';

interface IOrderHotelRefundProps {
    amountPaid: IPrice | undefined;
    totalPrice: IPrice | undefined;
    refund: IOrderPrice | undefined;
    penalty: IOrderPrice | undefined;
    appliedPromoCampaigns: IAppliedPromoCampaigns | undefined;
    hotelInfo: IBookHotelInfo;
    payment: IOrderPayment;
}

const OrderHotelRefund: React.FC<IOrderHotelRefundProps> = props => {
    const {
        amountPaid,
        totalPrice,
        refund,
        penalty,
        appliedPromoCampaigns,
        hotelInfo,
        payment,
    } = props;
    const {receipts, usesZeroFirstPayment} = payment;

    return (
        <Flex justifyContent="space-between" alignItems="baseline">
            {refund && (
                <FieldLabel
                    label={i18nBlock.refundTitle()}
                    labelColor="primary"
                    labelSize="m"
                    valueSize="xl"
                    valueWeight="medium"
                    between={1}
                >
                    <Price value={refund.amount} currency={refund.currency} />
                </FieldLabel>
            )}
            {!usesZeroFirstPayment && (
                <RefundReceiptsAndDocs
                    amountPaid={amountPaid}
                    totalPrice={totalPrice}
                    hotelInfo={hotelInfo}
                    refund={refund}
                    penalty={penalty}
                    appliedPromoCampaigns={appliedPromoCampaigns}
                    receipts={receipts}
                />
            )}
        </Flex>
    );
};

export default OrderHotelRefund;
