import React, {useMemo} from 'react';

import {IOrderPrice} from 'server/api/HotelsBookAPI/types/IOrder';
import {IAppliedPromoCampaigns} from 'types/hotels/offer/IHotelOffer';
import {IBookHotelInfo} from 'server/api/HotelsBookAPI/types/IBookOffer';

import IPrice from 'utilities/currency/PriceInterface';

import * as i18nBlock from 'i18n/account-OrderHotels-Price';

import RefundDetails from 'projects/account/pages/Order/components/OrderHotels/components/RefundDetails/RefundDetails';
import CommonDetailsModal from 'projects/account/pages/Order/components/OrderHotels/components/DetailsModal/DetailsModal';

interface IRefundDetailsModalProps {
    amountPaid: IPrice | undefined;
    totalPrice: IPrice | undefined;
    refund: IOrderPrice | undefined;
    penalty: IOrderPrice | undefined;
    appliedPromoCampaigns: IAppliedPromoCampaigns | undefined;
    hotelInfo: IBookHotelInfo;
    isVisible: boolean;
    onClose(): void;
}

const RefundDetailsModal: React.FC<IRefundDetailsModalProps> = props => {
    const {
        amountPaid,
        totalPrice,
        refund,
        penalty,
        appliedPromoCampaigns,
        hotelInfo,
        isVisible,
        onClose,
    } = props;

    const content = useMemo(() => {
        return (
            <RefundDetails
                amountPaid={amountPaid}
                totalPrice={totalPrice}
                refund={refund}
                penalty={penalty}
                appliedPromoCampaigns={appliedPromoCampaigns}
            />
        );
    }, [amountPaid, appliedPromoCampaigns, penalty, refund, totalPrice]);

    return (
        <CommonDetailsModal
            title={i18nBlock.refundDetails()}
            backButtonText={hotelInfo?.name}
            isVisible={isVisible}
            onClose={onClose}
        >
            {content}
        </CommonDetailsModal>
    );
};

export default React.memo(RefundDetailsModal);
